<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\OtherComponent;

class OtherComponentSeeder extends Seeder
{
    public function run(): void
    {
        $components = [
            [
                'name' => 'Cleat',
                'material' => 'MAHONI',
                'price_per_unit' => 1000,
                'unit' => 'pcs',
                'description' => 'Cleat kayu mahoni untuk penopang',
            ],
            [
                'name' => 'Support Drawer',
                'material' => 'MAHONI',
                'price_per_unit' => 1500,
                'unit' => 'pcs',
                'description' => 'Support drawer kayu mahoni',
            ],
            [
                'name' => 'Cleat Drawer',
                'material' => 'MAHONI',
                'price_per_unit' => 1200,
                'unit' => 'pcs',
                'description' => 'Cleat khusus untuk drawer',
            ],
        ];

        foreach ($components as $component) {
            OtherComponent::create($component);
        }
    }
}