<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', 'Dashboard') - Kasir Calculator</title>
    <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">
    @stack('styles')
</head>
<body>
    <!-- Navbar -->
    <div class="navbar">
        <a href="#" class="navbar-brand">
            <img src="{{ asset('assets/images/perusahaan.png') }}" alt="Logo">
            <span>KAYU MEBEL INDONESIA</span>
        </a>
        <div style="display: flex; align-items: center; gap: 20px;">
            <span style="color: var(--gray-600); font-size: 14px;">{{ Auth::user()->name }}</span>
            <form action="{{ route('logout') }}" method="POST" style="margin: 0;">
                @csrf
                <button type="submit" class="btn btn-secondary" style="padding: 8px 16px;">Logout</button>
            </form>
        </div>
    </div>

    <div class="container-fluid">
        <!-- Sidebar -->
        <aside class="sidebar">
            @yield('sidebar')
        </aside>

        <!-- Main Content -->
        <main class="main-content">
            @yield('content')
        </main>
    </div>

    @stack('scripts')
</body>
</html>