@extends('layouts.app')

@section('title', 'Tambah Buyer')

@section('sidebar')
<ul class="sidebar-menu">
    <li><a href="{{ route('superadmin.dashboard') }}">📊 Dashboard</a></li>
    <li><a href="{{ route('superadmin.buyers.index') }}" class="active">👥 Buyers</a></li>
    <li><a href="{{ route('superadmin.products.index') }}">📦 Products</a></li>
    <li><a href="{{ route('superadmin.materials.index') }}">🪵 Materials</a></li>
    <li><a href="{{ route('superadmin.veneers.index') }}">🎨 Veneers</a></li>
    <li><a href="{{ route('superadmin.components.index') }}">🔧 Components</a></li>
    <li><a href="{{ route('superadmin.dimensions.index') }}">📐 Dimensions</a></li>
</ul>
@endsection

@section('content')
<div style="margin-bottom: 30px;">
    <h1 style="font-size: 28px; color: var(--gray-800); margin-bottom: 10px;">Tambah Buyer Baru</h1>
    <p style="color: var(--gray-600);">Isi form di bawah untuk menambah buyer</p>
</div>

<div class="card" style="max-width: 800px;">
    <form action="{{ route('superadmin.buyers.store') }}" method="POST">
        @csrf

        <div class="form-group">
            <label for="name">Nama Buyer *</label>
            <input type="text" id="name" name="name" class="form-control" value="{{ old('name') }}" required>
            @error('name')
                <span class="error-message">{{ $message }}</span>
            @enderror
        </div>

        <div class="form-group">
            <label for="code">Kode Buyer *</label>
            <input type="text" id="code" name="code" class="form-control" value="{{ old('code') }}" placeholder="Contoh: EA001" required>
            @error('code')
                <span class="error-message">{{ $message }}</span>
            @enderror
        </div>

        <div class="form-group">
            <label for="email">Email</label>
            <input type="email" id="email" name="email" class="form-control" value="{{ old('email') }}" placeholder="buyer@example.com">
            @error('email')
                <span class="error-message">{{ $message }}</span>
            @enderror
        </div>

        <div class="form-group">
            <label for="phone">No. Telepon</label>
            <input type="text" id="phone" name="phone" class="form-control" value="{{ old('phone') }}" placeholder="+62xxx">
            @error('phone')
                <span class="error-message">{{ $message }}</span>
            @enderror
        </div>

        <div class="form-group">
            <label for="address">Alamat</label>
            <textarea id="address" name="address" class="form-control" rows="4" placeholder="Alamat lengkap buyer">{{ old('address') }}</textarea>
            @error('address')
                <span class="error-message">{{ $message }}</span>
            @enderror
        </div>

        <div class="form-group">
            <label style="display: flex; align-items: center; cursor: pointer;">
                <input type="checkbox" name="is_active" value="1" checked style="width: auto; margin-right: 8px;">
                <span>Status Aktif</span>
            </label>
        </div>

        <div style="display: flex; gap: 10px; margin-top: 30px;">
            <button type="submit" class="btn btn-primary">Simpan</button>
            <a href="{{ route('superadmin.buyers.index') }}" class="btn btn-secondary">Batal</a>
        </div>
    </form>
</div>
@endsection

@push('styles')
<style>
    .form-group {
        margin-bottom: 20px;
    }

    .form-group label {
        display: block;
        margin-bottom: 8px;
        color: var(--gray-700);
        font-weight: 600;
        font-size: 14px;
    }

    .error-message {
        color: #ef4444;
        font-size: 12px;
        margin-top: 5px;
        display: block;
    }
</style>
@endpush