@extends('layouts.app')

@section('title', 'Data Buyers')

@section('sidebar')
<ul class="sidebar-menu">
    <li><a href="{{ route('superadmin.dashboard') }}">📊 Dashboard</a></li>
    <li><a href="{{ route('superadmin.buyers.index') }}" class="active">👥 Buyers</a></li>
    <li><a href="{{ route('superadmin.products.index') }}">📦 Products</a></li>
    <li><a href="{{ route('superadmin.materials.index') }}">🪵 Materials</a></li>
    <li><a href="{{ route('superadmin.veneers.index') }}">🎨 Veneers</a></li>
    <li><a href="{{ route('superadmin.components.index') }}">🔧 Components</a></li>
    <li><a href="{{ route('superadmin.dimensions.index') }}">📐 Dimensions</a></li>
</ul>
@endsection

@section('content')
<div style="margin-bottom: 30px; display: flex; justify-content: space-between; align-items: center;">
    <div>
        <h1 style="font-size: 28px; color: var(--gray-800); margin-bottom: 10px;">Data Buyers</h1>
        <p style="color: var(--gray-600);">Kelola data buyer/customer</p>
    </div>
    <a href="{{ route('superadmin.buyers.create') }}" class="btn btn-primary">+ Tambah Buyer</a>
</div>

@if(session('success'))
<div style="background: #d1fae5; border: 1px solid #86efac; padding: 12px 20px; border-radius: 8px; margin-bottom: 20px; color: #065f46;">
    {{ session('success') }}
</div>
@endif

<div class="card">
    <table style="width: 100%; border-collapse: collapse;">
        <thead>
            <tr style="background: var(--gray-100); text-align: left;">
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300);">#</th>
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300);">Kode</th>
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300);">Nama</th>
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300);">Email</th>
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300);">Phone</th>
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300);">Status</th>
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300); text-align: center;">Aksi</th>
            </tr>
        </thead>
        <tbody>
            @forelse($buyers as $index => $buyer)
            <tr>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200);">{{ $buyers->firstItem() + $index }}</td>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200);"><strong>{{ $buyer->code }}</strong></td>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200);">{{ $buyer->name }}</td>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200);">{{ $buyer->email ?? '-' }}</td>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200);">{{ $buyer->phone ?? '-' }}</td>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200);">
                    @if($buyer->is_active)
                        <span style="background: #d1fae5; color: #065f46; padding: 4px 12px; border-radius: 12px; font-size: 12px;">Aktif</span>
                    @else
                        <span style="background: #fee2e2; color: #991b1b; padding: 4px 12px; border-radius: 12px; font-size: 12px;">Nonaktif</span>
                    @endif
                </td>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200); text-align: center;">
                    <a href="{{ route('superadmin.buyers.edit', $buyer->id) }}" class="btn btn-secondary" style="padding: 6px 12px; margin-right: 5px;">Edit</a>
                    <form action="{{ route('superadmin.buyers.destroy', $buyer->id) }}" method="POST" style="display: inline-block;" onsubmit="return confirm('Yakin ingin menghapus buyer ini?')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn" style="padding: 6px 12px; background: #ef4444; color: white;">Hapus</button>
                    </form>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="7" style="padding: 40px; text-align: center; color: var(--gray-500);">
                    Belum ada data buyer. <a href="{{ route('superadmin.buyers.create') }}" style="color: var(--primary-green);">Tambah buyer pertama</a>
                </td>
            </tr>
            @endforelse
        </tbody>
    </table>

    <div style="margin-top: 20px;">
        {{ $buyers->links() }}
    </div>
</div>
@endsection