@extends('layouts.app')

@section('title', 'Data Materials')

@section('sidebar')
<ul class="sidebar-menu">
    <li><a href="{{ route('superadmin.dashboard') }}">📊 Dashboard</a></li>
    <li><a href="{{ route('superadmin.buyers.index') }}">👥 Buyers</a></li>
    <li><a href="{{ route('superadmin.products.index') }}">📦 Products</a></li>
    <li><a href="{{ route('superadmin.materials.index') }}" class="active">🪵 Materials</a></li>
    <li><a href="{{ route('superadmin.veneers.index') }}">🎨 Veneers</a></li>
    <li><a href="{{ route('superadmin.components.index') }}">🔧 Components</a></li>
    <li><a href="{{ route('superadmin.dimensions.index') }}">📐 Dimensions</a></li>
</ul>
@endsection

@section('content')
<div style="margin-bottom: 30px; display: flex; justify-content: space-between; align-items: center;">
    <div>
        <h1 style="font-size: 28px; color: var(--gray-800); margin-bottom: 10px;">Data Materials</h1>
        <p style="color: var(--gray-600);">Kelola data material (Panel, Solid, MDF)</p>
    </div>
    <a href="{{ route('superadmin.materials.create') }}" class="btn btn-primary">+ Tambah Material</a>
</div>

@if(session('success'))
<div style="background: #d1fae5; border: 1px solid #86efac; padding: 12px 20px; border-radius: 8px; margin-bottom: 20px; color: #065f46;">
    {{ session('success') }}
</div>
@endif

<!-- Filter by Category -->
<div style="margin-bottom: 20px; display: flex; gap: 10px; flex-wrap: wrap;">
    <a href="{{ route('superadmin.materials.index') }}" class="btn btn-secondary" style="padding: 8px 16px;">Semua</a>
    <a href="{{ route('superadmin.materials.index', ['category' => 'panel']) }}" class="btn btn-secondary" style="padding: 8px 16px;">Panel</a>
    <a href="{{ route('superadmin.materials.index', ['category' => 'solid']) }}" class="btn btn-secondary" style="padding: 8px 16px;">Solid</a>
    <a href="{{ route('superadmin.materials.index', ['category' => 'mdf']) }}" class="btn btn-secondary" style="padding: 8px 16px;">MDF</a>
    <a href="{{ route('superadmin.materials.index', ['category' => 'other']) }}" class="btn btn-secondary" style="padding: 8px 16px;">Other</a>
</div>

<div class="grid grid-4">
    @forelse($materials as $material)
    <div class="card" style="position: relative;">
        <!-- Badge Category -->
        <div style="position: absolute; top: 15px; right: 15px; display: flex; gap: 5px; flex-direction: column; align-items: flex-end;">
            @php
                $categoryColors = [
                    'panel' => ['bg' => '#dbeafe', 'text' => '#1e40af'],
                    'solid' => ['bg' => '#fef3c7', 'text' => '#92400e'],
                    'mdf' => ['bg' => '#e0e7ff', 'text' => '#3730a3'],
                    'veneer' => ['bg' => '#fce7f3', 'text' => '#831843'],
                    'other' => ['bg' => '#f3f4f6', 'text' => '#374151'],
                ];
                $color = $categoryColors[$material->category] ?? $categoryColors['other'];
            @endphp
            <span style="background: {{ $color['bg'] }}; color: {{ $color['text'] }}; padding: 4px 12px; border-radius: 12px; font-size: 11px; font-weight: 600; text-transform: uppercase;">
                {{ $material->category }}
            </span>
            @if($material->is_active)
                <span style="background: #d1fae5; color: #065f46; padding: 4px 12px; border-radius: 12px; font-size: 11px; font-weight: 600;">Aktif</span>
            @else
                <span style="background: #fee2e2; color: #991b1b; padding: 4px 12px; border-radius: 12px; font-size: 11px; font-weight: 600;">Nonaktif</span>
            @endif
        </div>

        <!-- Icon -->
        <div style="width: 80px; height: 80px; background: {{ $color['bg'] }}; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 15px;">
            <span style="font-size: 40px;">
                @if($material->category == 'panel') 📋
                @elseif($material->category == 'solid') 🪵
                @elseif($material->category == 'mdf') 📦
                @elseif($material->category == 'veneer') 🎨
                @else 🔧
                @endif
            </span>
        </div>

        <h3 style="font-size: 18px; color: var(--gray-800); margin-bottom: 5px; text-align: center;">{{ $material->name }}</h3>
        <p style="color: var(--gray-600); font-size: 14px; text-align: center; margin-bottom: 15px;">
            Tebal: <strong>{{ $material->thickness }} mm</strong>
        </p>

        <!-- Harga -->
        <div style="background: var(--gray-50); padding: 12px; border-radius: 8px; margin-bottom: 15px;">
            @if($material->price_per_m2)
                <p style="font-size: 12px; color: var(--gray-600); margin-bottom: 5px;">Harga per M²</p>
                <p style="font-size: 20px; font-weight: 700; color: var(--primary-green);">Rp {{ number_format($material->price_per_m2, 0, ',', '.') }}</p>
            @endif
            @if($material->price_per_unit)
                <p style="font-size: 12px; color: var(--gray-600); margin-bottom: 5px;">Harga per {{ $material->unit }}</p>
                <p style="font-size: 20px; font-weight: 700; color: var(--primary-green);">Rp {{ number_format($material->price_per_unit, 0, ',', '.') }}</p>
            @endif
        </div>

        <div style="display: flex; gap: 10px;">
            <a href="{{ route('superadmin.materials.edit', $material->id) }}" class="btn btn-secondary" style="flex: 1; text-align: center; text-decoration: none;">Edit</a>
            <form action="{{ route('superadmin.materials.destroy', $material->id) }}" method="POST" style="flex: 1;" onsubmit="return confirm('Yakin ingin menghapus material ini?')">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn" style="width: 100%; background: #ef4444; color: white;">Hapus</button>
            </form>
        </div>
    </div>
    @empty
    <div style="grid-column: 1 / -1; text-align: center; padding: 60px; color: var(--gray-500);">
        <div style="font-size: 64px; margin-bottom: 20px;">🪵</div>
        <p style="font-size: 18px; margin-bottom: 10px;">Belum ada data material</p>
        <a href="{{ route('superadmin.materials.create') }}" style="color: var(--primary-green); font-weight: 600;">Tambah material pertama</a>
    </div>
    @endforelse
</div>

<div style="margin-top: 30px;">
    {{ $materials->links() }}
</div>
@endsection