

<?php $__env->startSection('title', 'Data Products'); ?>

<?php $__env->startSection('sidebar'); ?>
<ul class="sidebar-menu">
    <li><a href="<?php echo e(route('superadmin.dashboard')); ?>">📊 Dashboard</a></li>
    <li><a href="<?php echo e(route('superadmin.buyers.index')); ?>">👥 Buyers</a></li>
    <li><a href="<?php echo e(route('superadmin.products.index')); ?>" class="active">📦 Products</a></li>
    <li><a href="<?php echo e(route('superadmin.materials.index')); ?>">🪵 Materials</a></li>
    <li><a href="<?php echo e(route('superadmin.veneers.index')); ?>">🎨 Veneers</a></li>
    <li><a href="<?php echo e(route('superadmin.components.index')); ?>">🔧 Components</a></li>
    <li><a href="<?php echo e(route('superadmin.dimensions.index')); ?>">📐 Dimensions</a></li>
</ul>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div style="margin-bottom: 30px; display: flex; justify-content: space-between; align-items: center;">
    <div>
        <h1 style="font-size: 28px; color: var(--gray-800); margin-bottom: 10px;">Data Products</h1>
        <p style="color: var(--gray-600);">Kelola data produk furniture</p>
    </div>
    <a href="<?php echo e(route('superadmin.products.create')); ?>" class="btn btn-primary">+ Tambah Product</a>
</div>

<?php if(session('success')): ?>
<div style="background: #d1fae5; border: 1px solid #86efac; padding: 12px 20px; border-radius: 8px; margin-bottom: 20px; color: #065f46;">
    <?php echo e(session('success')); ?>

</div>
<?php endif; ?>

<div class="grid grid-3">
    <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <div class="card" style="position: relative;">
        <?php if($product->image): ?>
            <img src="<?php echo e(asset('assets/images/products/' . $product->image)); ?>" alt="<?php echo e($product->name); ?>" style="width: 100%; height: 200px; object-fit: cover; border-radius: 8px; margin-bottom: 15px;">
        <?php else: ?>
            <div style="width: 100%; height: 200px; background: var(--gray-200); border-radius: 8px; display: flex; align-items: center; justify-content: center; margin-bottom: 15px;">
                <span style="font-size: 48px;">📦</span>
            </div>
        <?php endif; ?>
        
        <div style="position: absolute; top: 15px; right: 15px;">
            <?php if($product->is_active): ?>
                <span style="background: #d1fae5; color: #065f46; padding: 4px 12px; border-radius: 12px; font-size: 12px; font-weight: 600;">Aktif</span>
            <?php else: ?>
                <span style="background: #fee2e2; color: #991b1b; padding: 4px 12px; border-radius: 12px; font-size: 12px; font-weight: 600;">Nonaktif</span>
            <?php endif; ?>
        </div>

        <h3 style="font-size: 18px; color: var(--gray-800); margin-bottom: 5px;"><?php echo e($product->name); ?></h3>
        <p style="color: var(--primary-green); font-weight: 600; font-size: 14px; margin-bottom: 10px;"><?php echo e($product->code); ?></p>
        <p style="color: var(--gray-600); font-size: 14px; margin-bottom: 15px; line-height: 1.5;">
            <?php echo e($product->description ? Str::limit($product->description, 80) : 'Tidak ada deskripsi'); ?>

        </p>

        <div style="display: flex; gap: 10px;">
            <a href="<?php echo e(route('superadmin.products.edit', $product->id)); ?>" class="btn btn-secondary" style="flex: 1; text-align: center; text-decoration: none;">Edit</a>
            <form action="<?php echo e(route('superadmin.products.destroy', $product->id)); ?>" method="POST" style="flex: 1;" onsubmit="return confirm('Yakin ingin menghapus product ini?')">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="btn" style="width: 100%; background: #ef4444; color: white;">Hapus</button>
            </form>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <div style="grid-column: 1 / -1; text-align: center; padding: 60px; color: var(--gray-500);">
        <div style="font-size: 64px; margin-bottom: 20px;">📦</div>
        <p style="font-size: 18px; margin-bottom: 10px;">Belum ada data product</p>
        <a href="<?php echo e(route('superadmin.products.create')); ?>" style="color: var(--primary-green); font-weight: 600;">Tambah product pertama</a>
    </div>
    <?php endif; ?>
</div>

<div style="margin-top: 30px;">
    <?php echo e($products->links()); ?>

</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\kasir_calculator\resources\views/superadmin/products/index.blade.php ENDPATH**/ ?>