

<?php $__env->startSection('title', 'Data Dimensions'); ?>

<?php $__env->startSection('sidebar'); ?>
<ul class="sidebar-menu">
    <li><a href="<?php echo e(route('superadmin.dashboard')); ?>">📊 Dashboard</a></li>
    <li><a href="<?php echo e(route('superadmin.buyers.index')); ?>">👥 Buyers</a></li>
    <li><a href="<?php echo e(route('superadmin.products.index')); ?>">📦 Products</a></li>
    <li><a href="<?php echo e(route('superadmin.materials.index')); ?>">🪵 Materials</a></li>
    <li><a href="<?php echo e(route('superadmin.veneers.index')); ?>">🎨 Veneers</a></li>
    <li><a href="<?php echo e(route('superadmin.components.index')); ?>">🔧 Components</a></li>
    <li><a href="<?php echo e(route('superadmin.dimensions.index')); ?>" class="active">📐 Dimensions</a></li>
</ul>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div style="margin-bottom: 30px; display: flex; justify-content: space-between; align-items: center;">
    <div>
        <h1 style="font-size: 28px; color: var(--gray-800); margin-bottom: 10px;">Data Dimensions</h1>
        <p style="color: var(--gray-600);">Kelola data dimensi (Lebar & Panjang untuk dropdown)</p>
    </div>
    <a href="<?php echo e(route('superadmin.dimensions.create')); ?>" class="btn btn-primary">+ Tambah Dimension</a>
</div>

<?php if(session('success')): ?>
<div style="background: #d1fae5; border: 1px solid #86efac; padding: 12px 20px; border-radius: 8px; margin-bottom: 20px; color: #065f46;">
    <?php echo e(session('success')); ?>

</div>
<?php endif; ?>

<!-- Filter by Type -->
<div style="margin-bottom: 20px; display: flex; gap: 10px;">
    <a href="<?php echo e(route('superadmin.dimensions.index')); ?>" class="btn btn-secondary" style="padding: 8px 16px;">Semua</a>
    <a href="<?php echo e(route('superadmin.dimensions.index', ['type' => 'lebar'])); ?>" class="btn btn-secondary" style="padding: 8px 16px;">Lebar</a>
    <a href="<?php echo e(route('superadmin.dimensions.index', ['type' => 'panjang'])); ?>" class="btn btn-secondary" style="padding: 8px 16px;">Panjang</a>
</div>

<div class="card">
    <table style="width: 100%; border-collapse: collapse;">
        <thead>
            <tr style="background: var(--gray-100); text-align: left;">
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300);">#</th>
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300);">Nilai (mm)</th>
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300);">Tipe</th>
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300);">Status</th>
                <th style="padding: 12px; border-bottom: 2px solid var(--gray-300); text-align: center;">Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $dimensions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $dimension): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200);"><?php echo e($dimensions->firstItem() + $index); ?></td>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200);"><strong style="font-size: 18px; color: var(--primary-green);"><?php echo e($dimension->value); ?></strong> mm</td>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200);">
                    <?php if($dimension->type == 'lebar'): ?>
                        <span style="background: #dbeafe; color: #1e40af; padding: 4px 12px; border-radius: 12px; font-size: 12px; font-weight: 600; text-transform: uppercase;">Lebar</span>
                    <?php else: ?>
                        <span style="background: #fef3c7; color: #92400e; padding: 4px 12px; border-radius: 12px; font-size: 12px; font-weight: 600; text-transform: uppercase;">Panjang</span>
                    <?php endif; ?>
                </td>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200);">
                    <?php if($dimension->is_active): ?>
                        <span style="background: #d1fae5; color: #065f46; padding: 4px 12px; border-radius: 12px; font-size: 12px;">Aktif</span>
                    <?php else: ?>
                        <span style="background: #fee2e2; color: #991b1b; padding: 4px 12px; border-radius: 12px; font-size: 12px;">Nonaktif</span>
                    <?php endif; ?>
                </td>
                <td style="padding: 12px; border-bottom: 1px solid var(--gray-200); text-align: center;">
                    <a href="<?php echo e(route('superadmin.dimensions.edit', $dimension->id)); ?>" class="btn btn-secondary" style="padding: 6px 12px; margin-right: 5px;">Edit</a>
                    <form action="<?php echo e(route('superadmin.dimensions.destroy', $dimension->id)); ?>" method="POST" style="display: inline-block;" onsubmit="return confirm('Yakin ingin menghapus dimension ini?')">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn" style="padding: 6px 12px; background: #ef4444; color: white;">Hapus</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="5" style="padding: 40px; text-align: center; color: var(--gray-500);">
                    Belum ada data dimension. <a href="<?php echo e(route('superadmin.dimensions.create')); ?>" style="color: var(--primary-green);">Tambah dimension pertama</a>
                </td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div style="margin-top: 20px;">
        <?php echo e($dimensions->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\kasir_calculator\resources\views/superadmin/dimensions/index.blade.php ENDPATH**/ ?>