

<?php $__env->startSection('title', 'Data Components'); ?>

<?php $__env->startSection('sidebar'); ?>
<ul class="sidebar-menu">
    <li><a href="<?php echo e(route('superadmin.dashboard')); ?>">📊 Dashboard</a></li>
    <li><a href="<?php echo e(route('superadmin.buyers.index')); ?>">👥 Buyers</a></li>
    <li><a href="<?php echo e(route('superadmin.products.index')); ?>">📦 Products</a></li>
    <li><a href="<?php echo e(route('superadmin.materials.index')); ?>">🪵 Materials</a></li>
    <li><a href="<?php echo e(route('superadmin.veneers.index')); ?>">🎨 Veneers</a></li>
    <li><a href="<?php echo e(route('superadmin.components.index')); ?>" class="active">🔧 Components</a></li>
    <li><a href="<?php echo e(route('superadmin.dimensions.index')); ?>">📐 Dimensions</a></li>
</ul>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div style="margin-bottom: 30px; display: flex; justify-content: space-between; align-items: center;">
    <div>
        <h1 style="font-size: 28px; color: var(--gray-800); margin-bottom: 10px;">Data Components</h1>
        <p style="color: var(--gray-600);">Kelola data komponen lain (Cleat, Support Drawer, dll)</p>
    </div>
    <a href="<?php echo e(route('superadmin.components.create')); ?>" class="btn btn-primary">+ Tambah Component</a>
</div>

<?php if(session('success')): ?>
<div style="background: #d1fae5; border: 1px solid #86efac; padding: 12px 20px; border-radius: 8px; margin-bottom: 20px; color: #065f46;">
    <?php echo e(session('success')); ?>

</div>
<?php endif; ?>

<div class="grid grid-3">
    <?php $__empty_1 = true; $__currentLoopData = $components; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $component): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <div class="card" style="position: relative;">
        <!-- Badge Status -->
        <div style="position: absolute; top: 15px; right: 15px;">
            <?php if($component->is_active): ?>
                <span style="background: #d1fae5; color: #065f46; padding: 4px 12px; border-radius: 12px; font-size: 11px; font-weight: 600;">Aktif</span>
            <?php else: ?>
                <span style="background: #fee2e2; color: #991b1b; padding: 4px 12px; border-radius: 12px; font-size: 11px; font-weight: 600;">Nonaktif</span>
            <?php endif; ?>
        </div>

        <!-- Icon -->
        <div style="width: 80px; height: 80px; background: #e0e7ff; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin: 0 auto 15px;">
            <span style="font-size: 40px;">🔧</span>
        </div>

        <h3 style="font-size: 18px; color: var(--gray-800); margin-bottom: 5px; text-align: center;"><?php echo e($component->name); ?></h3>
        <p style="color: var(--gray-600); font-size: 14px; text-align: center; margin-bottom: 15px;">
            Material: <strong><?php echo e($component->material); ?></strong>
        </p>

        <!-- Harga -->
        <div style="background: var(--gray-50); padding: 12px; border-radius: 8px; margin-bottom: 10px;">
            <p style="font-size: 12px; color: var(--gray-600); margin-bottom: 5px;">Harga per <?php echo e($component->unit); ?></p>
            <p style="font-size: 20px; font-weight: 700; color: var(--primary-green);">Rp <?php echo e(number_format($component->price_per_unit, 0, ',', '.')); ?></p>
        </div>

        <?php if($component->description): ?>
        <p style="font-size: 13px; color: var(--gray-600); margin-bottom: 15px; text-align: center;"><?php echo e(Str::limit($component->description, 60)); ?></p>
        <?php endif; ?>

        <div style="display: flex; gap: 10px;">
            <a href="<?php echo e(route('superadmin.components.edit', $component->id)); ?>" class="btn btn-secondary" style="flex: 1; text-align: center; text-decoration: none;">Edit</a>
            <form action="<?php echo e(route('superadmin.components.destroy', $component->id)); ?>" method="POST" style="flex: 1;" onsubmit="return confirm('Yakin ingin menghapus component ini?')">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="btn" style="width: 100%; background: #ef4444; color: white;">Hapus</button>
            </form>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <div style="grid-column: 1 / -1; text-align: center; padding: 60px; color: var(--gray-500);">
        <div style="font-size: 64px; margin-bottom: 20px;">🔧</div>
        <p style="font-size: 18px; margin-bottom: 10px;">Belum ada data component</p>
        <a href="<?php echo e(route('superadmin.components.create')); ?>" style="color: var(--primary-green); font-weight: 600;">Tambah component pertama</a>
    </div>
    <?php endif; ?>
</div>

<div style="margin-top: 30px;">
    <?php echo e($components->links()); ?>

</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\kasir_calculator\resources\views/superadmin/components/index.blade.php ENDPATH**/ ?>