<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class PositionsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $positions = [
            [
                'position_name' => 'Driver',
                'department' => 'Operasional',
                'description' => 'Bertanggung jawab untuk mengantarkan produk dan keperluan perusahaan',
                'requirements' => 'Min. SMA/SMK, memiliki SIM A/B, pengalaman mengemudi min 2 tahun',
                'salary_range_min' => 2500000.00,
                'salary_range_max' => 4000000.00,
                'is_active' => true,
                'location' => 'Sidoarjo',
                'employment_type' => 'full-time',
                'posted_date' => Carbon::now()->subDays(7),
                'closing_date' => Carbon::now()->addDays(30),
            ],
            [
                'position_name' => 'IT Support',
                'department' => 'Information Technology',
                'description' => 'Mengelola sistem IT perusahaan dan troubleshooting hardware/software',
                'requirements' => 'Min. D3 Teknik Informatika/Komputer, menguasai jaringan dan hardware',
                'salary_range_min' => 4000000.00,
                'salary_range_max' => 7000000.00,
                'is_active' => true,
                'location' => 'Sidoarjo',
                'employment_type' => 'full-time',
                'posted_date' => Carbon::now()->subDays(5),
                'closing_date' => Carbon::now()->addDays(30),
            ],
            [
                'position_name' => 'Operator CNC',
                'department' => 'Produksi',
                'description' => 'Mengoperasikan mesin CNC untuk produksi komponen presisi',
                'requirements' => 'Min. SMK Teknik Mesin, pengalaman operasi CNC min 1 tahun',
                'salary_range_min' => 3500000.00,
                'salary_range_max' => 5500000.00,
                'is_active' => true,
                'location' => 'Sidoarjo',
                'employment_type' => 'full-time',
                'posted_date' => Carbon::now()->subDays(3),
                'closing_date' => Carbon::now()->addDays(30),
            ],
            [
                'position_name' => 'Operator Produksi',
                'department' => 'Produksi',
                'description' => 'Mengoperasikan mesin produksi dan memastikan target produksi tercapai',
                'requirements' => 'Min. SMA/SMK, mampu bekerja shift, teliti dan disiplin',
                'salary_range_min' => 3000000.00,
                'salary_range_max' => 4500000.00,
                'is_active' => true,
                'location' => 'Sidoarjo',
                'employment_type' => 'full-time',
                'posted_date' => Carbon::now()->subDays(10),
                'closing_date' => Carbon::now()->addDays(30),
            ],
            [
                'position_name' => 'Staff Administrasi',
                'department' => 'Administration',
                'description' => 'Mengelola administrasi umum dan dokumentasi perusahaan',
                'requirements' => 'Min. D3, menguasai Microsoft Office, komunikasi yang baik',
                'salary_range_min' => 3500000.00,
                'salary_range_max' => 5000000.00,
                'is_active' => true,
                'location' => 'Sidoarjo',
                'employment_type' => 'full-time',
                'posted_date' => Carbon::now()->subDays(2),
                'closing_date' => Carbon::now()->addDays(30),
            ],
            [
                'position_name' => 'Security',
                'department' => 'Security',
                'description' => 'Menjaga keamanan dan ketertiban di lingkungan perusahaan',
                'requirements' => 'Min. SMA, pengalaman security, fisik sehat, memiliki surat izin satpam',
                'salary_range_min' => 2800000.00,
                'salary_range_max' => 3800000.00,
                'is_active' => true,
                'location' => 'Sidoarjo',
                'employment_type' => 'full-time',
                'posted_date' => Carbon::now()->subDays(4),
                'closing_date' => Carbon::now()->addDays(30),
            ],
            [
                'position_name' => 'QC Inspector',
                'department' => 'Quality Control',
                'description' => 'Melakukan inspeksi kualitas produk sesuai standar perusahaan',
                'requirements' => 'Min. D3 Teknik, teliti, detail oriented, pengalaman QC lebih disukai',
                'salary_range_min' => 4000000.00,
                'salary_range_max' => 6000000.00,
                'is_active' => true,
                'location' => 'Sidoarjo',
                'employment_type' => 'full-time',
                'posted_date' => Carbon::now()->subDays(6),
                'closing_date' => Carbon::now()->addDays(30),
            ],
            [
                'position_name' => 'Drafter',
                'department' => 'Engineering',
                'description' => 'Membuat gambar teknis dan dokumen engineering',
                'requirements' => 'Min. D3 Teknik Mesin/Sipil, menguasai AutoCAD, SolidWorks',
                'salary_range_min' => 4500000.00,
                'salary_range_max' => 7000000.00,
                'is_active' => true,
                'location' => 'Sidoarjo',
                'employment_type' => 'full-time',
                'posted_date' => Carbon::now()->subDays(8),
                'closing_date' => Carbon::now()->addDays(30),
            ],
            [
                'position_name' => 'Staff Purchasing',
                'department' => 'Procurement',
                'description' => 'Mengelola pengadaan barang dan jasa untuk kebutuhan perusahaan',
                'requirements' => 'Min. D3, pengalaman purchasing min 1 tahun, negosiasi yang baik',
                'salary_range_min' => 4000000.00,
                'salary_range_max' => 6500000.00,
                'is_active' => true,
                'location' => 'Sidoarjo',
                'employment_type' => 'full-time',
                'posted_date' => Carbon::now()->subDays(1),
                'closing_date' => Carbon::now()->addDays(30),
            ],
            [
                'position_name' => 'Cleaning Service',
                'department' => 'Housekeeping',
                'description' => 'Menjaga kebersihan dan kerapihan lingkungan kerja',
                'requirements' => 'Min. SMP, pengalaman housekeeping lebih disukai, rajin dan teliti',
                'salary_range_min' => 2500000.00,
                'salary_range_max' => 3500000.00,
                'is_active' => true,
                'location' => 'Sidoarjo',
                'employment_type' => 'full-time',
                'posted_date' => Carbon::now()->subDays(9),
                'closing_date' => Carbon::now()->addDays(30),
            ],
            [
                'position_name' => 'Staff Accounting',
                'department' => 'Finance',
                'description' => 'Mengelola pembukuan dan transaksi keuangan perusahaan',
                'requirements' => 'Min. D3 Akuntansi/Ekonomi, pengalaman accounting min 1 tahun',
                'salary_range_min' => 4000000.00,
                'salary_range_max' => 6500000.00,
                'is_active' => true,
                'location' => 'Sidoarjo',
                'employment_type' => 'full-time',
                'posted_date' => Carbon::now()->subDays(12),
                'closing_date' => Carbon::now()->addDays(30),
            ],
            [
                'position_name' => 'Engineer',
                'department' => 'Engineering',
                'description' => 'Merancang, mengembangkan dan memelihara sistem engineering',
                'requirements' => 'Min. S1 Teknik, pengalaman engineering min 2 tahun, problem solving yang baik',
                'salary_range_min' => 6000000.00,
                'salary_range_max' => 10000000.00,
                'is_active' => true,
                'location' => 'Sidoarjo',
                'employment_type' => 'full-time',
                'posted_date' => Carbon::now()->subDays(11),
                'closing_date' => Carbon::now()->addDays(30),
            ],
            [
                'position_name' => 'Marketing Staff',
                'department' => 'Marketing',
                'description' => 'Mengelola kegiatan pemasaran dan promosi produk perusahaan',
                'requirements' => 'Min. D3 Marketing/Komunikasi, kreatif, menguasai digital marketing',
                'salary_range_min' => 3500000.00,
                'salary_range_max' => 5500000.00,
                'is_active' => true,
                'location' => 'Sidoarjo',
                'employment_type' => 'full-time',
                'posted_date' => Carbon::now()->subDays(13),
                'closing_date' => Carbon::now()->addDays(30),
            ],
            [
                'position_name' => 'General Worker',
                'department' => 'General',
                'description' => 'Posisi untuk berbagai kebutuhan umum perusahaan',
                'requirements' => 'Min. SMA/SMK, siap ditempatkan di berbagai divisi sesuai kebutuhan',
                'salary_range_min' => 2800000.00,
                'salary_range_max' => 4000000.00,
                'is_active' => true,
                'location' => 'Sidoarjo',
                'employment_type' => 'full-time',
                'posted_date' => Carbon::now()->subDays(14),
                'closing_date' => Carbon::now()->addDays(30),
            ],
        ];

        foreach ($positions as $position) {
            DB::table('positions')->insert(array_merge($position, [
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ]));
        }

        $this->command->info('Positions seeded successfully!');
    }
}