{{-- resources/views/employees/index.blade.php --}}
@extends('layouts.app')

@section('title', 'Karyawan Diterima')
@section('page-title', 'Karyawan Diterima')

@section('content')
@php
    $totalAccepted  = $accepted->count();
    $totalConverted = $employeesByCandidate->count();
    $totalPending   = $totalAccepted - $totalConverted;

    // Build opsi filter dari data yang ada
    $branchOptions = collect();
    $deptOptions   = collect();
    $posOptions    = collect();

    foreach ($accepted as $cand) {
        $pos = $cand->position ?? null;
        if ($pos) {
            if (!empty($pos->location))       $branchOptions->push("PT. Kayu Mebel Indonesia - {$pos->location}");
            if (!empty($pos->department))     $deptOptions->push($pos->department);
            if (!empty($pos->position_name))  $posOptions->push($pos->position_name);
        } else {
            if (!empty($cand->position_applied)) $posOptions->push($cand->position_applied);
        }
    }

    $branchOptions = $branchOptions->filter()->unique()->sort()->values();
    $deptOptions   = $deptOptions->filter()->unique()->sort()->values();
    $posOptions    = $posOptions->filter()->unique()->sort()->values();
@endphp

{{-- Header actions --}}
<div class="mb-6 flex items-center justify-between">
  <div class="space-y-1">
    <h2 class="text-2xl font-bold text-gray-900">Karyawan Diterima</h2>
    <p class="text-sm text-gray-500">Kelola kandidat accepted yang sudah/akan dikonversi menjadi karyawan.</p>
  </div>
  <div class="flex gap-2">
    <a href="{{ route('candidates.index') }}"
       class="inline-flex items-center gap-2 px-4 py-2 rounded-lg bg-blue-600 text-white hover:bg-blue-700 transition">
      <i class="fas fa-users"></i><span>Kandidat</span>
    </a>
  </div>
</div>

{{-- Metrik --}}
<div class="grid grid-cols-1 sm:grid-cols-3 gap-4 mb-6">
  <div class="bg-white border border-gray-200 rounded-xl p-5 shadow-sm">
    <p class="text-sm font-semibold text-gray-600">Total Accepted</p>
    <p class="mt-2 text-3xl font-bold text-gray-900">{{ $totalAccepted }}</p>
  </div>
  <div class="bg-white border border-gray-200 rounded-xl p-5 shadow-sm">
    <p class="text-sm font-semibold text-gray-600">Sudah Jadi Karyawan</p>
    <p class="mt-2 text-3xl font-bold text-emerald-700">{{ $totalConverted }}</p>
  </div>
  <div class="bg-white border border-gray-200 rounded-xl p-5 shadow-sm">
    <p class="text-sm font-semibold text-gray-600">Menunggu Dilengkapi</p>
    <p class="mt-2 text-3xl font-bold text-amber-700">{{ $totalPending }}</p>
  </div>
</div>

{{-- Filters --}}
<div class="bg-white border border-gray-200 rounded-xl p-5 shadow-sm mb-6">
  <div class="flex items-center justify-between mb-4">
    <h3 class="text-lg font-semibold text-gray-900 flex items-center gap-2">
      <i class="fas fa-filter text-gray-500"></i> Filter
    </h3>
    <button id="btn-clear"
            class="inline-flex items-center gap-2 px-3 py-2 rounded-lg border border-gray-300 text-gray-700 hover:bg-gray-50">
      <i class="fas fa-rotate-left"></i> Reset
    </button>
  </div>

  <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-4">
    <div>
      <label class="block text-sm font-medium text-gray-700 mb-1">Cari</label>
      <input id="q" type="text" placeholder="Cari nama / kode kandidat..."
             class="w-full px-3 py-2 rounded-lg border border-gray-300 focus:ring-2 focus:ring-primary focus:border-transparent">
    </div>

    <div>
      <label class="block text-sm font-medium text-gray-700 mb-1">Branch</label>
      <select id="f-branch"
              class="w-full px-3 py-2 rounded-lg border border-gray-300 bg-white focus:ring-2 focus:ring-primary focus:border-transparent">
        <option value="">Semua Branch</option>
        @foreach($branchOptions as $b)
          <option value="{{ $b }}">{{ $b }}</option>
        @endforeach
      </select>
    </div>

    <div>
      <label class="block text-sm font-medium text-gray-700 mb-1">Department</label>
      <select id="f-dept"
              class="w-full px-3 py-2 rounded-lg border border-gray-300 bg-white focus:ring-2 focus:ring-primary focus:border-transparent">
        <option value="">Semua Dept</option>
        @foreach($deptOptions as $d)
          <option value="{{ $d }}">{{ $d }}</option>
        @endforeach
      </select>
    </div>

    <div>
      <label class="block text-sm font-medium text-gray-700 mb-1">Position</label>
      <select id="f-pos"
              class="w-full px-3 py-2 rounded-lg border border-gray-300 bg-white focus:ring-2 focus:ring-primary focus:border-transparent">
        <option value="">Semua Posisi</option>
        @foreach($posOptions as $p)
          <option value="{{ $p }}">{{ $p }}</option>
        @endforeach
      </select>
    </div>

    <div>
      <label class="block text-sm font-medium text-gray-700 mb-1">Status Assignment</label>
      <select id="f-assign"
              class="w-full px-3 py-2 rounded-lg border border-gray-300 bg-white focus:ring-2 focus:ring-primary focus:border-transparent">
        <option value="">Semua</option>
        <option value="1">Sudah dibuat</option>
        <option value="0">Belum dibuat</option>
      </select>
    </div>
  </div>
</div>

{{-- Tabel --}}
<div class="bg-white border border-gray-200 rounded-xl shadow-sm">
  <div class="px-5 pt-5">
    <h2 class="text-lg font-semibold text-gray-900 flex items-center gap-2">
      <i class="fas fa-user-check text-gray-500"></i> Daftar Karyawan Diterima
    </h2>
  </div>

  <div class="overflow-x-auto">
    <table class="min-w-full divide-y divide-gray-200">
      <thead class="bg-gray-50">
        <tr class="text-left text-xs font-semibold text-gray-600 uppercase tracking-wider">
          <th class="px-5 py-3 w-[280px]">Kandidat</th>
          <th class="px-5 py-3">Organisasi</th>
          <th class="px-5 py-3">Kontak</th>
          <th class="px-5 py-3">Status</th>
          <th class="px-5 py-3 w-[220px]">Aksi</th>
        </tr>
      </thead>
      <tbody id="rows" class="bg-white divide-y divide-gray-100">
        @forelse($accepted as $cand)
          @php
            $pos   = $cand->position ?? null;
            $emp   = $employeesByCandidate[$cand->id] ?? null;
            $branch = $pos && $pos->location ? "PT. Kayu Mebel Indonesia - {$pos->location}" : '—';
            $dept   = $pos->department ?? '—';
            $pname  = $pos->position_name ?? ($cand->position_applied ?: '—');
            $assign = $emp ? 1 : 0;
          @endphp
          <tr class="row"
              data-branch="{{ $branch }}"
              data-dept="{{ $dept }}"
              data-pos="{{ $pname }}"
              data-assign="{{ $assign }}"
              data-q="{{ strtolower(($cand->full_name ?? '').' '.($cand->candidate_code ?? '')) }}">
            <td class="px-5 py-4 align-top">
              <div class="font-semibold text-gray-900">{{ $cand->full_name }}</div>
              <div class="text-xs text-gray-500">{{ $cand->candidate_code }}</div>
            </td>
            <td class="px-5 py-4 align-top">
              <div class="text-gray-900">{{ $pname }}</div>
              <div class="text-xs text-gray-500">{{ $dept }}</div>
              <div class="text-xs text-gray-500">{{ $branch }}</div>
            </td>
            <td class="px-5 py-4 align-top">
              <div class="text-gray-900">{{ $cand->email ?? '—' }}</div>
              <div class="text-xs text-gray-500">{{ $cand->phone_number ?? '—' }}</div>
            </td>
            <td class="px-5 py-4 align-top">
              <div>
                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-emerald-50 text-emerald-700 border border-emerald-200">
                  Accepted
                </span>
              </div>
              @if($emp)
                <div class="text-xs text-emerald-700 mt-2">
                  <i class="fas fa-check-circle"></i> Employee: {{ $emp->employee_code ?: '—' }}
                </div>
              @else
                <div class="text-xs text-amber-700 mt-2">
                  <i class="fas fa-clock"></i> Belum dibuat
                </div>
              @endif
            </td>
            <td class="px-5 py-4 align-top">
              <div class="flex flex-wrap gap-2">
                @if($emp)
                  <a href="{{ route('employees.show', $emp->id) }}"
                     class="inline-flex items-center gap-2 px-3 py-2 rounded-lg bg-sky-600 text-white hover:bg-sky-700">
                    <i class="fas fa-eye"></i> Lihat
                  </a>
                @else
                  <a href="{{ route('employees.create-from-candidate', $cand->id) }}"
                     class="inline-flex items-center gap-2 px-3 py-2 rounded-lg bg-primary text-white hover:bg-indigo-700">
                    <i class="fas fa-plus"></i> Lengkapi
                  </a>
                @endif
                <a href="{{ route('candidates.show', $cand->id) }}"
                   class="inline-flex items-center justify-center w-10 h-10 rounded-lg border border-gray-300 text-gray-700 hover:bg-gray-50">
                  <i class="fas fa-user"></i>
                </a>
              </div>
            </td>
          </tr>
        @empty
          <tr>
            <td colspan="5" class="px-5 py-12">
              <div class="flex flex-col items-center justify-center text-gray-500">
                <i class="fas fa-user-check text-3xl mb-2"></i>
                <p class="text-sm">Belum ada kandidat berstatus accepted.</p>
              </div>
            </td>
          </tr>
        @endforelse
      </tbody>
    </table>
  </div>
</div>
@endsection

@push('scripts')
<script>
(function(){
  const $q = document.getElementById('q');
  const $b = document.getElementById('f-branch');
  const $d = document.getElementById('f-dept');
  const $p = document.getElementById('f-pos');
  const $a = document.getElementById('f-assign');
  const $clear = document.getElementById('btn-clear');
  const rows = Array.from(document.querySelectorAll('#rows .row'));

  const norm = v => (v||'').toString().toLowerCase().trim();

  function apply(){
    const fq = norm($q.value);
    const fb = norm($b.value);
    const fd = norm($d.value);
    const fp = norm($p.value);
    const fa = norm($a.value);

    rows.forEach(tr => {
      const q  = (tr.dataset.q || '');
      const rb = norm(tr.dataset.branch);
      const rd = norm(tr.dataset.dept);
      const rp = norm(tr.dataset.pos);
      const ra = (tr.dataset.assign || '').toString();

      const okQ = !fq || q.includes(fq);
      const okB = !fb || rb === fb;
      const okD = !fd || rd === fd;
      const okP = !fp || rp === fp;
      const okA = !fa || ra === fa;

      tr.style.display = (okQ && okB && okD && okP && okA) ? '' : 'none';
    });
  }

  [$q,$b,$d,$p,$a].forEach(el => el.addEventListener('input', apply));
  [$b,$d,$p,$a].forEach(el => el.addEventListener('change', apply));
  $clear.addEventListener('click', () => { $q.value=''; $b.value=''; $d.value=''; $p.value=''; $a.value=''; apply(); });

  apply();
})();
</script>

@endpush
