<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <title>@yield('title', config('app.name'))</title>

  <!-- Tailwind -->
  <script src="https://cdn.tailwindcss.com"></script>

  <!-- Font Awesome -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">

  @stack('styles')

  <script>
    tailwind.config = {
      theme: {
        extend: {
          colors: { primary: '#4f46e5', secondary: '#7c3aed' }
        }
      }
    }
  </script>

  <style>
    /* ===== Sidebar sizing & collapse ===== */
    #sidebar { width: 14rem; transition: width .25s ease, transform .25s ease; }
    #sidebar.collapsed { width: 3.5rem !important; }
    #sidebar.collapsed .label { display: none; }
    #sidebar.collapsed .center-when-collapsed { justify-content: center; }

    /* ===== Layering: sidebar > overlay > header/content ===== */
    #sidebar{ z-index:1050 !important; }
    #sidebar-overlay{ z-index:1040 !important; }
    .topbar-layer{ z-index:20 !important; }
    #main-content{ position:relative; z-index:1; }

    /* Kunci scroll saat sidebar mobile dibuka */
    body.no-scroll{ overflow:hidden; }
  </style>
</head>
<body class="bg-gray-50">
<div id="app" class="flex h-screen overflow-hidden">
  @auth
  <!-- ===== Sidebar ===== -->
  <aside id="sidebar"
    class="bg-white shadow-xl flex flex-col transform transition-all duration-300 ease-in-out
           fixed inset-y-0 left-0 z-[1050] -translate-x-full
           lg:static lg:inset-auto lg:left-auto lg:transform-none">

    <!-- Sidebar Header -->
    <div class="p-4 border-b border-gray-200">
      <div class="flex items-center space-x-3 center-when-collapsed">
        <img src="{{ asset('images/PT. KAYU MEBEL INDONESIA GROUP.png') }}"
             alt="Logo" class="w-8 h-8 rounded-lg object-contain" />
        <div class="font-bold text-base text-gray-800 label">HR System</div>
      </div>
    </div>

    <!-- User Panel -->
    <div class="p-4 bg-gradient-to-r from-primary to-secondary text-white">
      <div class="flex items-center space-x-3 center-when-collapsed">
        <div class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center">
          @if(Auth::user()->role === 'admin')
            <i class="fas fa-user-crown text-lg"></i>
          @elseif(Auth::user()->role === 'hr')
            <i class="fas fa-user-tie text-lg"></i>
          @else
            <i class="fas fa-user text-lg"></i>
          @endif
        </div>
        <div class="flex-1 min-w-0 label">
          <div class="font-semibold truncate">{{ Auth::user()->full_name }}</div>
          <div class="text-sm opacity-90 capitalize">{{ Auth::user()->role }}</div>
        </div>
      </div>
    </div>

    <!-- Navigation -->
    <nav class="flex-1 p-4 space-y-2">
      <a href="{{ route('dashboard') }}"
         class="flex items-center space-x-3 px-3 py-2 rounded-lg transition-all duration-200 center-when-collapsed
         {{ request()->routeIs('dashboard*') ? 'bg-primary text-white shadow-md' : 'text-gray-600 hover:bg-gray-100 hover:text-primary' }}">
        <i class="fas fa-gauge w-5 text-center"></i>
        <span class="label">Dashboard</span>
      </a>

      @if(in_array(Auth::user()->role, ['admin','hr']))
      <a href="{{ route('candidates.index') }}"
         class="flex items-center space-x-3 px-3 py-2 rounded-lg transition-all duration-200 center-when-collapsed
         {{ request()->routeIs('candidates.*') ? 'bg-primary text-white shadow-md' : 'text-gray-600 hover:bg-gray-100 hover:text-primary' }}">
        <i class="fas fa-user-tie w-5 text-center"></i>
        <span class="label">Kandidat</span>
      </a>

      <a href="{{ route('positions.index') }}"
         class="flex items-center space-x-3 px-3 py-2 rounded-lg transition-all duration-200 center-when-collapsed
         {{ request()->routeIs('positions.*') ? 'bg-primary text-white shadow-md' : 'text-gray-600 hover:bg-gray-100 hover:text-primary' }}">
        <i class="fas fa-briefcase w-5 text-center"></i>
        <span class="label">Posisi</span>
      </a>

      <a href="{{ route('employees.index') }}"
         class="flex items-center space-x-3 px-3 py-2 rounded-lg transition-all duration-200 center-when-collapsed
         {{ request()->routeIs('employees.*') ? 'bg-primary text-white shadow-md' : 'text-gray-600 hover:bg-gray-100 hover:text-primary' }}">
        <i class="fas fa-user-check w-5 text-center"></i>
        <span class="label">Karyawan Diterima</span>
      </a>

      {{-- ====== Item baru: Data Karyawan (Talenta) ====== --}}
      <a href="{{ route('talenta.employees.index') }}"
         class="flex items-center space-x-3 px-3 py-2 rounded-lg transition-all duration-200 center-when-collapsed
         {{ request()->routeIs('talenta.employees.*') ? 'bg-primary text-white shadow-md' : 'text-gray-600 hover:bg-gray-100 hover:text-primary' }}">
        <i class="fas fa-cloud-arrow-down w-5 text-center"></i>
        <span class="label">Data Karyawan (Talenta)</span>
      </a>
      @endif
    </nav>

    <!-- Logout -->
    <div class="p-4 border-t border-gray-200">
      <form action="{{ route('logout') }}" method="POST" id="logout-form">
        @csrf
        <button type="submit"
          class="w-full flex items-center space-x-3 px-3 py-2 rounded-lg text-red-600 hover:bg-red-50 hover:text-red-700 transition-all duration-200 center-when-collapsed">
          <i class="fas fa-sign-out-alt w-5 text-center"></i>
          <span class="label">Logout</span>
        </button>
      </form>
    </div>
  </aside>

  <!-- Overlay (mobile only) -->
  <div id="sidebar-overlay" class="fixed inset-0 bg-black/50 z-[1040] lg:hidden hidden"></div>

  <!-- ===== Main Area ===== -->
  <div class="flex-1 flex flex-col overflow-hidden">
    <!-- Topbar -->
    <nav class="bg-white shadow-sm border-b border-gray-200 px-4 py-3 topbar-layer sticky top-0">
      <div class="flex items-center justify-between">
        <div class="flex items-center space-x-3">
          <!-- Mobile toggle -->
          <button id="mobile-menu-button" class="lg:hidden text-gray-600 hover:text-gray-900 focus:outline-none">
            <i class="fas fa-bars text-xl"></i>
          </button>
          <!-- Desktop collapse toggle -->
          <button id="desktop-sidebar-toggle"
                  class="hidden lg:inline-flex items-center justify-center w-10 h-10 rounded-md hover:bg-gray-100 text-gray-700"
                  title="Toggle sidebar">
            <i class="fas fa-grip-lines"></i>
          </button>

          <h1 class="text-xl font-semibold text-gray-800 hidden sm:block">
            @yield('page-title', 'Dashboard')
          </h1>
        </div>

        {{-- === KANAN TOPBAR (di sinilah tombol akan muncul) === --}}
        <div class="flex items-center gap-3">
          {{-- Header actions dari halaman (mis. show.blade.php) --}}
          @hasSection('header-actions')
            <div class="hidden sm:flex items-center gap-2">
              @yield('header-actions')
            </div>
          @endif

          {{-- (Opsional) Notifikasi & sapaan --}}
          <button class="text-gray-600 hover:text-gray-900 relative">
            <i class="fas fa-bell text-lg"></i>
            <span class="absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full h-4 w-4 flex items-center justify-center">3</span>
          </button>
          <div class="hidden sm:flex items-center space-x-2 text-sm text-gray-600">
            <span>Welcome, {{ Auth::user()->full_name }}</span>
            <span class="bg-primary text-white px-2 py-1 rounded-full text-xs">{{ ucfirst(Auth::user()->role) }}</span>
          </div>
        </div>
      </div>
    </nav>

    <!-- Content -->
    <main id="main-content" class="flex-1 overflow-auto bg-gray-50 p-6">
      @yield('content')
    </main>
  </div>
  @else
    <!-- Guest -->
    <main class="flex-1">@yield('content')</main>
  @endauth
</div>

<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
document.addEventListener('DOMContentLoaded', function () {
  const sidebar   = document.getElementById('sidebar');
  const overlay   = document.getElementById('sidebar-overlay');
  const btnMobile = document.getElementById('mobile-menu-button');
  const btnDesk   = document.getElementById('desktop-sidebar-toggle');

  /* ===== Mobile: off-canvas open/close ===== */
  const openMobile  = () => { sidebar.classList.remove('-translate-x-full'); overlay.classList.remove('hidden'); document.body.classList.add('no-scroll'); };
  const closeMobile = () => { sidebar.classList.add('-translate-x-full');  overlay.classList.add('hidden');  document.body.classList.remove('no-scroll'); };

  btnMobile?.addEventListener('click', () => {
    if (sidebar.classList.contains('-translate-x-full')) openMobile(); else closeMobile();
  });
  overlay?.addEventListener('click', closeMobile);

  // Auto-close when clicking a link on mobile
  document.querySelectorAll('#sidebar a').forEach(a => {
    a.addEventListener('click', () => { if (window.innerWidth < 1024) closeMobile(); });
  });

  /* ===== Desktop: collapse width with persistence ===== */
  const KEY = 'sidebarCollapsedV1';
  const apply = (collapsed) => collapsed ? sidebar.classList.add('collapsed') : sidebar.classList.remove('collapsed');
  apply(localStorage.getItem(KEY) === 'true');

  btnDesk?.addEventListener('click', () => {
    const collapsed = sidebar.classList.toggle('collapsed');
    localStorage.setItem(KEY, collapsed ? 'true' : 'false');
  });

  // Ensure sidebar visible when resizing to desktop
  window.addEventListener('resize', () => {
    if (window.innerWidth >= 1024) {
      overlay?.classList.add('hidden');
      document.body.classList.remove('no-scroll');
      sidebar.classList.remove('-translate-x-full');
    }
  });

  /* ===== Logout confirm ===== */
  const logoutForm = document.getElementById('logout-form');
  if (logoutForm) {
    logoutForm.addEventListener('submit', function (e) {
      e.preventDefault();
      Swal.fire({
        title: 'Konfirmasi Logout',
        text: 'Apakah Anda yakin ingin keluar dari sistem?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#ef4444',
        cancelButtonColor: '#6b7280',
        confirmButtonText: 'Ya, Logout',
        cancelButtonText: 'Batal',
        reverseButtons: true
      }).then((result) => {
        if (result.isConfirmed) {
          Swal.fire({ title: 'Logging out...', allowOutsideClick: false, showConfirmButton: false, didOpen: () => Swal.showLoading() });
          logoutForm.submit();
        }
      });
    });
  }
});
</script>

@auth
<script>
// Optional AJAX logout
function ajaxLogout() {
  fetch('{{ route("logout") }}', {
    method: 'POST',
    headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}', 'Content-Type': 'application/json', 'Accept': 'application/json' }
  })
  .then(r => { if (r.ok) location.href = '{{ route("login") }}'; else throw new Error('Logout failed'); })
  .catch(() => Swal.fire({ title: 'Error', text: 'Terjadi kesalahan saat logout. Silakan coba lagi.', icon: 'error' }));
}
</script>
@endauth

@stack('scripts')
</body>
</html>
