{{-- resources/views/positions/trashed.blade.php --}}
@extends('layouts.app')

@section('title', 'Posisi Terhapus')
@section('page-title', 'Posisi Terhapus')

@push('styles')
<style>
  /* ====== Khusus halaman "Posisi Terhapus" ====== */
  .info-banner{background:linear-gradient(135deg,#fee2e2,#fecaca);border:1px solid #fca5a5;color:#991b1b;padding:14px 16px;border-radius:10px;margin-bottom:18px;display:flex;gap:10px;align-items:flex-start}
  .search-section{background:#fff;padding:16px;border:1px solid #e5e7eb;border-radius:12px;box-shadow:0 4px 16px rgba(0,0,0,.06);margin-bottom:18px}
  .search-container{position:relative;max-width:420px}
  .search-input{width:100%;padding:10px 14px 10px 40px;border:1px solid #e2e8f0;border-radius:10px;font-size:.95rem}
  .search-input:focus{outline:0;border-color:#4f46e5;box-shadow:0 0 0 3px rgba(79,70,229,.12)}
  .search-icon{position:absolute;left:12px;top:50%;transform:translateY(-50%);color:#718096}

  .table-container{background:#fff;border:1px solid #e5e7eb;border-radius:12px;box-shadow:0 4px 16px rgba(0,0,0,.06);overflow:hidden}
  .table-header{padding:14px 16px;border-bottom:1px solid #e5e7eb;display:flex;justify-content:space-between;align-items:center}
  .table-title{font-size:1.1rem;font-weight:700;color:#111827}
  .table-info{color:#6b7280;font-size:.9rem}
  .positions-table{width:100%;border-collapse:collapse}
  .positions-table th{background:#f9fafb;padding:12px;text-align:left;font-weight:700;color:#4b5563;font-size:.78rem;text-transform:uppercase;letter-spacing:.04em;border-bottom:2px solid #e5e7eb}
  .positions-table td{padding:14px;border-bottom:1px solid #e5e7eb;vertical-align:top}
  .positions-table tbody tr{transition:background .15s,opacity .15s;opacity:.9}
  .positions-table tbody tr:hover{background:#fff7f7;opacity:1}

  .position-info{display:flex;flex-direction:column}
  .position-name{font-weight:700;color:#111827;margin-bottom:4px}
  .position-department{font-size:.85rem;color:#6b7280}
  .position-location{font-size:.8rem;color:#9ca3af}

  .employment-badge{padding:4px 8px;border-radius:999px;font-size:.72rem;font-weight:700;letter-spacing:.02em}
  .employment-full-time{background:#dbeafe;color:#1e40af}
  .employment-part-time{background:#fef3c7;color:#92400e}
  .employment-contract{background:#e0e7ff;color:#3730a3}
  .employment-internship{background:#f3e8ff;color:#6b21a8}

  .status-badge{padding:4px 10px;border-radius:999px;font-size:.78rem;font-weight:600;display:inline-block;text-align:center}
  .status-deleted{background:#fecaca;color:#991b1b}

  .application-stats{display:flex;flex-direction:column;gap:4px}
  .stat-item{display:flex;justify-content:space-between;font-size:.88rem}
  .stat-label{color:#6b7280}
  .stat-value{font-weight:700;color:#111827}
  .stat-value.active{color:#dc2626}

  .date-info{font-size:.88rem;color:#6b7280}
  .deleted-date{color:#dc2626;font-weight:700}

  .action-dropdown{position:relative;display:inline-block}
  .action-btn{background:transparent;border:0;padding:8px;border-radius:8px;cursor:pointer;color:#6b7280}
  .action-btn:hover{color:#dc2626;background:#fff1f2}
  .dropdown-menu{position:absolute;right:0;top:100%;background:#fff;border:1px solid #e5e7eb;border-radius:10px;box-shadow:0 14px 30px rgba(0,0,0,.08);min-width:180px;z-index:30;display:none}
  .dropdown-menu.show{display:block}
  .dropdown-item{padding:10px 12px;color:#374151;text-decoration:none;display:flex;align-items:center;gap:10px;font-size:.92rem;background:none;border:0;width:100%;cursor:pointer}
  .dropdown-item:hover{background:#f9fafb;color:#4f46e5}
  .dropdown-item.danger:hover{background:#fff1f2;color:#dc2626}
  .dropdown-divider{height:1px;background:#e5e7eb;margin:6px 0}

  .empty-state{text-align:center;padding:56px 16px;color:#6b7280}
  .empty-state i{font-size:2.4rem;margin-bottom:10px;color:#e5e7eb}

  .pagination-container{padding:14px;border-top:1px solid #e5e7eb}

  .btn{display:inline-flex;align-items:center;gap:8px;padding:10px 14px;border-radius:10px;font-weight:700;border:1px solid transparent;text-decoration:none}
  .btn-primary{background:linear-gradient(135deg,#4f46e5,#7c3aed);color:#fff}
  .btn-primary:hover{filter:brightness(.98)}
  .btn-secondary{background:#6b7280;color:#fff}
  .btn-secondary:hover{background:#4b5563}

  .loading-overlay{position:fixed;inset:0;background:rgba(255,255,255,.8);display:none;align-items:center;justify-content:center;z-index:50}
  .loading-spinner{width:40px;height:40px;border:3px solid #e2e8f0;border-top-color:#dc2626;border-radius:50%;animation:spin 1s linear infinite}
  @keyframes spin{to{transform:rotate(360deg)}}

  @media (max-width: 1024px){
    .positions-table{font-size:.9rem}
    .positions-table th,.positions-table td{padding:10px}
  }
</style>
@endpush

@section('content')
  {{-- Header kecil + tombol --}}
  <div class="mb-6 flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
    <div>
      <div class="text-sm text-gray-500">
        <a href="{{ route('dashboard') }}" class="text-primary hover:underline">Dashboard</a>
        <span class="mx-1">/</span>
        <a href="{{ route('positions.index') }}" class="text-primary hover:underline">Posisi</a>
        <span class="mx-1">/</span>
        <span>Terhapus</span>
      </div>
      <h1 class="text-2xl font-bold text-gray-900 mt-1">Posisi Terhapus</h1>
    </div>
    <div class="flex gap-2">
      <a href="{{ route('positions.index') }}" class="btn btn-primary">
        <i class="fas fa-briefcase"></i> Posisi Aktif
      </a>
    </div>
  </div>

  {{-- Info banner --}}
  <div class="info-banner">
    <i class="fas fa-info-circle mt-0.5"></i>
    <div><strong>Informasi:</strong> Ini adalah daftar posisi yang telah dihapus (soft delete). Posisi dapat dipulihkan kembali jika diperlukan.</div>
  </div>

  {{-- Pencarian --}}
  <div class="search-section">
    <form method="GET">
      <div class="search-container">
        <i class="fas fa-search search-icon"></i>
        <input type="text" name="search" class="search-input" placeholder="Cari posisi yang dihapus..." value="{{ request('search') }}">
      </div>
    </form>
  </div>

  {{-- Tabel --}}
  <div class="table-container">
    <div class="table-header">
      <h3 class="table-title">Daftar Posisi Terhapus</h3>
      <span class="table-info">Total: {{ $positions->total() }} posisi terhapus</span>
    </div>

    <table class="positions-table">
      <thead>
        <tr>
          <th width="5%">No</th>
          <th width="25%">Posisi</th>
          <th width="15%">Tipe & Gaji</th>
          <th width="15%">Aplikasi</th>
          <th width="10%">Status</th>
          <th width="15%">Tanggal Hapus</th>
          <th width="10%">Aksi</th>
        </tr>
      </thead>
      <tbody>
        @forelse($positions as $index => $position)
          <tr>
            <td>{{ $positions->firstItem() + $index }}</td>
            <td>
              <div class="position-info">
                <div class="position-name">{{ $position->position_name }}</div>
                <div class="position-department">{{ $position->department }}</div>
                @if($position->location)
                  <div class="position-location"><i class="fas fa-map-marker-alt"></i> {{ $position->location }}</div>
                @endif
              </div>
            </td>
            <td>
              <div style="margin-bottom:6px">
                <span class="employment-badge employment-{{ str_replace('-', '-', $position->employment_type) }}">
                  {{ $position->employment_type_label }}
                </span>
              </div>
              <div style="font-size:.86rem;color:#6b7280">{{ $position->salary_range }}</div>
            </td>
            <td>
              <div class="application-stats">
                <div class="stat-item"><span class="stat-label">Total:</span><span class="stat-value">{{ $position->total_applications_count }}</span></div>
                @if($position->active_applications_count > 0)
                  <div class="stat-item"><span class="stat-label">Aktif:</span><span class="stat-value active">{{ $position->active_applications_count }}</span></div>
                @endif
              </div>
            </td>
            <td><span class="status-badge status-deleted">Terhapus</span></td>
            <td>
              <div class="date-info">
                <div class="deleted-date">{{ $position->deleted_at->format('d M Y') }}</div>
                <div style="font-size:.78rem;color:#9ca3af;margin-top:2px">{{ $position->deleted_at->format('H:i') }}</div>
              </div>
            </td>
            <td>
              <div class="action-dropdown">
                <button class="action-btn" onclick="toggleDropdown(this)"><i class="fas fa-ellipsis-v"></i></button>
                <div class="dropdown-menu">
                  <button class="dropdown-item" onclick="restorePosition({{ $position->id }}, '{{ addslashes($position->position_name) }}')">
                    <i class="fas fa-undo"></i> Pulihkan
                  </button>
                  <div class="dropdown-divider"></div>
                  <button class="dropdown-item danger"
                          onclick="permanentDelete({{ $position->id }}, '{{ addslashes($position->position_name) }}', {{ $position->total_applications_count }})">
                    <i class="fas fa-trash-alt"></i> Hapus Permanen
                  </button>
                </div>
              </div>
            </td>
          </tr>
        @empty
          <tr>
            <td colspan="7">
              <div class="empty-state">
                <i class="fas fa-trash-alt"></i>
                <p>Tidak ada posisi yang terhapus</p>
                @if(request()->filled('search'))
                  <small>Coba ubah kata kunci pencarian Anda</small>
                @endif
              </div>
            </td>
          </tr>
        @endforelse
      </tbody>
    </table>

    {{-- Pagination --}}
    @if($positions->hasPages())
      <div class="pagination-container">
        {{ $positions->appends(request()->query())->links() }}
      </div>
    @endif
  </div>

  {{-- Loading overlay --}}
  <div class="loading-overlay" id="loadingOverlay">
    <div class="loading-spinner"></div>
  </div>
@endsection

@push('scripts')
<script>
  // Auto-submit search (debounce)
  (function(){
    const input = document.querySelector('.search-input');
    if (!input) return;
    input.addEventListener('input', function(){
      clearTimeout(this.__t);
      this.__t = setTimeout(()=> this.closest('form').submit(), 500);
    });
  })();

  // Dropdown
  function toggleDropdown(btn){
    const dd = btn.nextElementSibling;
    document.querySelectorAll('.dropdown-menu').forEach(m => { if (m !== dd) m.classList.remove('show'); });
    dd.classList.toggle('show');
  }
  document.addEventListener('click', (e)=>{
    if (!e.target.closest('.action-dropdown')) {
      document.querySelectorAll('.dropdown-menu').forEach(m => m.classList.remove('show'));
    }
  });

  // CSRF
  function getCSRFToken(){
    const el = document.querySelector('meta[name="csrf-token"]');
    return el ? el.getAttribute('content') : '';
  }

  // Loading overlay helpers
  function showLoading(){ document.getElementById('loadingOverlay').style.display = 'flex'; }
  function hideLoading(){ document.getElementById('loadingOverlay').style.display = 'none'; }

  // Restore
  function restorePosition(id, name){
    Swal.fire({
      title: 'Pulihkan Posisi?',
      text: `Apakah Anda yakin ingin memulihkan posisi "${name}"?`,
      icon: 'question',
      showCancelButton: true,
      confirmButtonColor: '#10b981',
      cancelButtonColor: '#6b7280',
      confirmButtonText: 'Ya, Pulihkan',
      cancelButtonText: 'Batal'
    }).then((r)=>{
      if (!r.isConfirmed) return;
      showLoading();
      fetch(`/positions/${id}/restore`, {
        method: 'POST',
        headers: {'Content-Type':'application/json','X-CSRF-TOKEN': getCSRFToken()}
      }).then(res=>res.json())
       .then(data=>{
          hideLoading();
          if (data.success){
            Swal.fire({title:'Berhasil!',text:data.message,icon:'success',timer:1800,showConfirmButton:false})
              .then(()=>location.reload());
          }else{
            Swal.fire({title:'Gagal!',text:data.message||'Tidak dapat memulihkan posisi',icon:'error'});
          }
       }).catch(()=>{
          hideLoading();
          Swal.fire({title:'Error',text:'Terjadi kesalahan saat memulihkan posisi',icon:'error'});
       });
    });
  }

  // Force delete
  function permanentDelete(id, name, count){
    let warn = `Posisi "${name}" akan dihapus PERMANEN dan tidak dapat dipulihkan.`;
    if (count > 0) warn += `\n\nPeringatan: Posisi ini memiliki ${count} kandidat. Data kandidat tetap ada, namun referensi posisinya hilang.`;
    Swal.fire({
      title:'Hapus Permanen?',
      text: warn,
      icon:'warning',
      showCancelButton:true,
      confirmButtonColor:'#dc2626',
      cancelButtonColor:'#6b7280',
      confirmButtonText:'Ya, Hapus Permanen',
      cancelButtonText:'Batal'
    }).then((r)=>{
      if (!r.isConfirmed) return;
      Swal.fire({
        title:'Konfirmasi Akhir',
        text:'Ketik "HAPUS" untuk mengkonfirmasi penghapusan permanen:',
        input:'text',
        inputPlaceholder:'Ketik HAPUS',
        showCancelButton:true,
        confirmButtonColor:'#dc2626',
        cancelButtonColor:'#6b7280',
        confirmButtonText:'Hapus Permanen',
        cancelButtonText:'Batal',
        inputValidator:(v)=> v==='HAPUS' ? undefined : 'Anda harus mengetik "HAPUS"'
      }).then((r2)=>{
        if (!r2.isConfirmed) return;
        showLoading();
        fetch(`/positions/${id}/force-delete`, {
          method:'DELETE',
          headers:{'Content-Type':'application/json','X-CSRF-TOKEN': getCSRFToken()}
        }).then(res=>res.json())
          .then(data=>{
            hideLoading();
            if (data.success){
              Swal.fire({title:'Terhapus Permanen!',text:data.message,icon:'success',timer:2200,showConfirmButton:false})
                .then(()=>location.reload());
            }else{
              Swal.fire({title:'Gagal!',text:data.message||'Tidak dapat menghapus posisi',icon:'error'});
            }
          }).catch(()=>{
            hideLoading();
            Swal.fire({title:'Error',text:'Terjadi kesalahan saat menghapus posisi',icon:'error'});
          });
      });
    });
  }
</script>
@endpush
